#version 330
#extension GL_EXT_gpu_shader4 : enable
//Random patternMod01.fsh  by zOrg
//https://www.shadertoy.com/view/tlfcD7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0
// Unported License. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ 
// or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
// =========================================================================================================

mat2 r2d(float a){float cosa = cos(a);float sina = sin(a);return mat2(cosa,-sina,sina,cosa);}
const float PI = 3.14159265;
bool rng(float a, float mi, float ma)
{
  return (a>mi && a<ma)|| (a>ma && a<mi);
}
vec3 cols[4];

float sat(float a)
{
  return clamp(a,0.,1.);
}
float lenny(vec2 v)
{
  return abs(v.x)+abs(v.y);
}
float loz(vec2 uv, float sz)
{
  return lenny(uv)-sz;
}

float cir(vec2 uv, float r)
{
  return length(uv)-r;
}

void setup()
{
  cols[0] = .8*vec3(106, 48, 128)/255.;
  cols[1] = vec3(125, 44, 82)/255.;
  cols[2] = .8*vec3(232, 26, 77)/255.;
  cols[3] = .9*vec3(227, 187, 54)/255.;
}

float rdrLine(vec2 p, float tim)
{
  float xPosl = smoothstep(-1.,1., sin(tim))-.5;
  float xPosr = smoothstep(-1.,1., sin(tim+.5))-.5;
  float width = .5;
  float thick = .05;
  float line = float(rng(p.y+.1*sin((tim+p.x)*PI*5.), -thick,+thick) && rng(p.x,xPosl,xPosr));
  return line+.1*max(xPosl,.5)*sat(1.-length(p));
}

vec3 rdr(vec2 uv)
{

  setup();

  vec3 col;
  int i = 0;
  int cnt =16;
  float fcnt = float(cnt);
  float tim = iTime+(.5+.5*sin(iTime*.5))*floor(asin(sin(iTime*PI*2.)))+abs(sin(iTime*PI));
  tim*=.1;
    
  while (i<cnt)
  {
    float fi = float(i);
    col += rdrLine(uv-vec2(0.,(fi-fcnt/2.)*.05),fi*.1*tim+fi)*cols[int(mod(fi,4.))];
   ++i;
  }

  col *= cols[int(clamp(length(uv)*5.,0.,3.))];
  return col;
}

vec3 rdr2(vec2 uv)
{
  vec2 uv2 = uv*r2d(uv.x);
  uv2.x += sin(uv.y*15.)*.1;
  vec3 col = rdr(uv2).yzx+rdr(uv*length(uv+vec2(sin(iTime),cos(iTime))*.5))*.5;
  return col;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  vec2 uv = gl_FragCoord.xy / iResolution.xx;
  uv -= vec2(.5)*iResolution.xy/iResolution.xx;
  uv *= 2.+sin(iTime*.25)*.5;
  vec3 col = rdr2(abs(r2d(pow(length(uv*r2d(uv.y))+sin(iTime+uv.x)*.1,5.))*uv));

  col*=col*(abs(sin(iTime))+.5)*2.;
  col += 5.*cols[0]*pow(sat(1.-lenny(uv)),5.);
  col = pow(col,vec3(1./2.2));
  col = mix(col, col.zxy, sin(iTime*.2)*.5+.5);
  gl_FragColor = vec4(col.zyx, 1.0);
}

